/*
 * Database tables used to describe the fabric
 */

/*
 * Table "hosts"
 *   hostname - DBD_STR
 *   sw_version - DBD_STR
 */
#define LF_TABLE_HOSTS "hosts"
#define LF_TABLE_HOSTS_PREV  "hosts_pre_1_3"
enum {
  LF_TABLE_HOST_HOSTNAME,
  LF_TABLE_HOST_FW_TYPE,
  LF_TABLE_HOST_FLAGS,
  LF_TABLE_HOST_STATUS,
  LF_TABLE_HOST_NUMCOLS
};
#ifdef _LF_DEFINE_TABLES_
static struct lf_col_desc lf_table_host_cols[] = {
  { "hostname", DBD_STR },
  { "fw_type", DBD_INT },
  { "flags", DBD_INT },
  { "status", DBD_INT }
};
#endif

/*
 * Table "nics"
 */
#define LF_TABLE_NICS "nics"
#define LF_TABLE_NICS_PREV "nics_pre_1_3"
enum {
  LF_TABLE_NIC_HOSTNAME,
  LF_TABLE_NIC_HOST_NIC_ID,
  LF_TABLE_NIC_MAC_ADDR,
  LF_TABLE_NIC_SERIAL_NO,
  LF_TABLE_NIC_PRODUCT_ID,
  LF_TABLE_NIC_PARTITION,
  LF_TABLE_NIC_STATUS,
  LF_TABLE_NIC_NUMCOLS
};
#ifdef _LF_DEFINE_TABLES_
static struct lf_col_desc lf_table_nic_cols[] = {
  { "hostname", DBD_STR },
  { "host_nic_id", DBD_INT },
  { "mac_addr", DBD_MAC },
  { "serial_no", DBD_STR },
  { "product_id", DBD_STR },
  { "partition", DBD_INT },
  { "status", DBD_INT }
};
#endif

/*
 * Table "links"
 */
#define LF_TABLE_LINKS "links"
#define LF_TABLE_LINKS_PREV "links_pre_1_3"
enum {
  LF_TABLE_LINK_NAME_1,
  LF_TABLE_LINK_SLOT_1,
  LF_TABLE_LINK_PORT_1,
  LF_TABLE_LINK_SUBPORT_1,
  LF_TABLE_LINK_NAME_2,
  LF_TABLE_LINK_SLOT_2,
  LF_TABLE_LINK_PORT_2,
  LF_TABLE_LINK_SUBPORT_2,
  LF_TABLE_LINK_STATUS,
  LF_TABLE_LINK_NUMCOLS
};
#ifdef _LF_DEFINE_TABLES_
static struct lf_col_desc lf_table_link_cols[] = {
  { "name_1", DBD_STR },
  { "slot_1", DBD_INT },
  { "port_1", DBD_INT },
  { "subport_1", DBD_INT },
  { "name_2", DBD_STR },
  { "slot_2", DBD_INT },
  { "port_2", DBD_INT },
  { "subport_2", DBD_INT },
  { "status", DBD_INT }
};
#endif

/* Table "enclosures"
 */
#define LF_TABLE_ENCLOSURES "enclosures"
#define LF_TABLE_ENCLOSURES_PREV "enclosures_pre_1_3"
enum {
  LF_TABLE_ENCLOSURE_NAME,
  LF_TABLE_ENCLOSURE_PRODUCT_ID,
  LF_TABLE_ENCLOSURE_STATUS,
  LF_TABLE_ENCLOSURE_NUMCOLS
};
#ifdef _LF_DEFINE_TABLES_
static struct lf_col_desc lf_table_enclosure_cols[] = {
  { "name", DBD_STR },
  { "product_id", DBD_STR },
  { "status", DBD_INT }
};
#endif


/*
 * Table "linecards"
 */
#define LF_TABLE_LINECARDS "linecards"
#define LF_TABLE_LINECARDS_PREV "linecards_pre_1_3"
enum {
  LF_TABLE_LINECARD_ENCLOSURE_NAME,
  LF_TABLE_LINECARD_ENCLOSURE_SLOT,
  LF_TABLE_LINECARD_SERIAL_NO,
  LF_TABLE_LINECARD_PRODUCT_ID,
  LF_TABLE_LINECARD_STATUS,
  LF_TABLE_LINECARD_NUMCOLS
};
#ifdef _LF_DEFINE_TABLES_
static struct lf_col_desc lf_table_linecard_cols[] = {
  { "enclosure_name", DBD_STR },
  { "enclosure_slot", DBD_INT },
  { "serial_no", DBD_STR },
  { "product_id", DBD_STR },
  { "status", DBD_INT }
};
#endif

struct lf_fabric_db {
  db_database_ptr_t database;	/* database handle */

  /* If true, recreate the database. This is typically associated with 
   * a software upgrade where the table changes
   */
  int db_needs_rewrite;

  db_table_ptr_t host_tbl;	/* hosts table */
  int host_colids[LF_TABLE_HOST_NUMCOLS];

  db_table_ptr_t nic_tbl;	/* NIC table */
  int nic_colids[LF_TABLE_NIC_NUMCOLS];

  db_table_ptr_t enclosure_tbl;	/* enclosure table */
  int enclosure_colids[LF_TABLE_ENCLOSURE_NUMCOLS];

  db_table_ptr_t linecard_tbl;	/* linecard table */
  int linecard_colids[LF_TABLE_LINECARD_NUMCOLS];

  db_table_ptr_t link_tbl;	/* link table */
  int link_colids[LF_TABLE_LINK_NUMCOLS];

};


/*
 * Prototypes
 */
int lf_rewrite_fabric_db(struct lf_fabric_db *fdp, struct lf_fabric *fp);
int lf_load_hosts(struct lf_fabric_db *fdp, lf_fabric_t *);
int lf_load_nics(struct lf_fabric_db *fdp, lf_fabric_t *);
int lf_load_enclosures(struct lf_fabric_db *fdp, lf_fabric_t *);
int lf_load_linecards(struct lf_fabric_db *fdp, lf_fabric_t *);
int lf_load_links(struct lf_fabric_db *fdp, lf_fabric_t *);
struct lf_fabric_db *lf_fabric_db_handle(db_database_ptr_t dp);
struct lf_fabric *lf_load_fabric(struct lf_fabric_db *fdp);
void lf_close_fabric_db(struct lf_fabric_db *fdp);

int lf_remove_link_from_db(struct lf_fabric_db *fdp, char *name,
  int slot, int port, int subport);
int lf_remove_nic_from_db(struct lf_fabric_db *fdp, char *hostname,
  int nic_id);
int lf_remove_host_from_db(struct lf_fabric_db *fdp, char *hostname);
int lf_add_host_to_db(struct lf_fabric_db *fdp, struct lf_host *hp);
int lf_add_nic_to_db(struct lf_fabric_db *fdp, struct lf_nic *nicp);
int lf_add_topo_link_to_db(struct lf_fabric_db *fdp, union lf_node *np1,
  int port1, enum lf_db_status status);
int lf_add_phys_link_to_db(struct lf_fabric_db *fdp, union lf_node *np1,
  int port1, enum lf_db_status status);
int lf_remove_linecard_from_db(struct lf_fabric_db *fdp, char *name, int slot);
int lf_add_linecard_to_db(struct lf_fabric_db *fdp, struct lf_linecard *lp);
int lf_remove_enclosure_from_db(struct lf_fabric_db *fdp, char *name);
int lf_add_enclosure_to_db(struct lf_fabric_db *fdp, struct lf_enclosure *ep);
int lf_flush_fabric_db(struct lf_fabric_db *fdp);
int lf_create_host_table(struct lf_fabric_db *fdp);
int lf_create_nic_table(struct lf_fabric_db *fdp);
int lf_create_link_table(struct lf_fabric_db *fdp);
int lf_create_enclosure_table(struct lf_fabric_db *fdp);
int lf_create_linecard_table(struct lf_fabric_db *fdp);
int lf_clear_fabric_db(struct lf_fabric_db *fdp);
int lf_add_fabric_to_db(struct lf_fabric_db *fdp, struct lf_fabric *fp);

